/*
 * Decompiled with CFR 0.152.
 */
package de.mennomax.astikorcarts.entity;

import de.mennomax.astikorcarts.AstikorCarts;
import de.mennomax.astikorcarts.config.AstikorCartsConfig;
import de.mennomax.astikorcarts.network.clientbound.UpdateDrawnMessage;
import de.mennomax.astikorcarts.util.CartWheel;
import de.mennomax.astikorcarts.world.AstikorWorld;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IEquipable;
import net.minecraft.entity.IRideable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.HandSide;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.TransportationHelper;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.ICollisionReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.fml.network.PacketDistributor;

public abstract class AbstractDrawnEntity
extends Entity
implements IEntityAdditionalSpawnData {
    private static final DataParameter<Integer> TIME_SINCE_HIT = EntityDataManager.func_187226_a(AbstractDrawnEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> FORWARD_DIRECTION = EntityDataManager.func_187226_a(AbstractDrawnEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> DAMAGE_TAKEN = EntityDataManager.func_187226_a(AbstractDrawnEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final UUID PULL_SLOWLY_MODIFIER_UUID = UUID.fromString("49B0E52E-48F2-4D89-BED7-4F5DF26F1263");
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYaw;
    private double lerpPitch;
    protected List<CartWheel> wheels;
    private int pullingId = -1;
    private UUID pullingUUID = null;
    protected double spacing = 2.4;
    public Entity pulling;
    protected AbstractDrawnEntity drawn;

    public AbstractDrawnEntity(EntityType<? extends Entity> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
        this.field_70138_W = 1.2f;
        this.field_70156_m = true;
        this.initWheels();
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        return this.func_174813_aQ().func_72314_b(3.0, 3.0, 3.0);
    }

    public void func_70071_h_() {
        if (this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        if (!this.func_189652_ae()) {
            this.func_213293_j(0.0, this.func_213322_ci().field_72448_b - 0.08, 0.0);
        }
        if (this.getDamageTaken() > 0.0f) {
            this.setDamageTaken(this.getDamageTaken() - 1.0f);
        }
        super.func_70071_h_();
        this.tickLerp();
        if (this.pulling == null) {
            this.field_70125_A = 25.0f;
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.attemptReattach();
        }
        for (Entity entity : this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ(), EntityPredicates.func_200823_a((Entity)this))) {
            this.func_70108_f(entity);
        }
    }

    public void pulledTick() {
        if (this.pulling == null) {
            return;
        }
        Vector3d targetVec = this.getRelativeTargetVec(1.0f);
        this.handleRotation(targetVec);
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        if (this.pulling.func_233570_aj_()) {
            targetVec = new Vector3d(targetVec.field_72450_a, 0.0, targetVec.field_72449_c);
        }
        double targetVecLength = targetVec.func_72433_c();
        double r = 0.2;
        double diff = targetVecLength - this.spacing;
        Vector3d move = Math.abs(diff) < 0.2 ? this.func_213322_ci() : this.func_213322_ci().func_178787_e(targetVec.func_178788_d(targetVec.func_72432_b().func_186678_a(this.spacing + 0.2 * Math.signum(diff))));
        this.field_70122_E = true;
        double startX = this.func_226277_ct_();
        double startY = this.func_226278_cu_();
        double startZ = this.func_226281_cx_();
        this.func_213315_a(MoverType.SELF, move);
        if (!this.func_70089_S()) {
            return;
        }
        this.addStats(this.func_226277_ct_() - startX, this.func_226278_cu_() - startY, this.func_226281_cx_() - startZ);
        if (this.field_70170_p.field_72995_K) {
            for (CartWheel wheel : this.wheels) {
                wheel.tick();
            }
        } else {
            targetVec = this.getRelativeTargetVec(1.0f);
            if (targetVec.func_72433_c() > this.spacing + 1.0) {
                this.setPulling(null);
            }
        }
        this.updatePassengers();
        if (this.drawn != null) {
            this.drawn.pulledTick();
        }
    }

    private void addStats(double x, double y, double z) {
        int cm;
        if (!this.field_70170_p.field_72995_K && (cm = Math.round(MathHelper.func_76133_a((double)(x * x + y * y + z * z)) * 100.0f)) > 0) {
            for (Entity passenger : this.func_184188_bt()) {
                if (!(passenger instanceof PlayerEntity)) continue;
                ((PlayerEntity)passenger).func_195067_a(AstikorCarts.Stats.CART_ONE_CM, cm);
            }
        }
    }

    public void initWheels() {
        this.wheels = Arrays.asList(new CartWheel(this, 0.9f), new CartWheel(this, -0.9f));
    }

    public boolean shouldRemovePulling() {
        if (this.field_70123_F) {
            this.func_213303_ch().func_72441_c(0.0, (double)this.func_70047_e(), 0.0);
            Vector3d start = new Vector3d(this.func_226277_ct_(), this.func_226278_cu_() + (double)this.func_213302_cg(), this.func_226281_cx_());
            Vector3d end = new Vector3d(this.pulling.func_226277_ct_(), this.pulling.func_226278_cu_() + (double)(this.pulling.func_213302_cg() / 2.0f), this.pulling.func_226281_cx_());
            BlockRayTraceResult result = this.field_70170_p.func_217299_a(new RayTraceContext(start, end, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
            return result.func_216346_c() == RayTraceResult.Type.BLOCK;
        }
        return false;
    }

    public void updatePassengers() {
        for (Entity passenger : this.func_184188_bt()) {
            this.func_184232_k(passenger);
        }
    }

    @Nullable
    public Entity getPulling() {
        return this.pulling;
    }

    public void setPulling(Entity entityIn) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.canBePulledBy(entityIn)) {
                if (entityIn == null) {
                    if (this.pulling instanceof LivingEntity) {
                        ModifiableAttributeInstance attr = ((LivingEntity)this.pulling).func_110148_a(Attributes.field_233821_d_);
                        if (attr != null) {
                            attr.func_188479_b(PULL_SLOWLY_MODIFIER_UUID);
                        }
                    } else if (this.pulling instanceof AbstractDrawnEntity) {
                        ((AbstractDrawnEntity)this.pulling).drawn = null;
                    }
                    AstikorCarts.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new UpdateDrawnMessage(-1, this.func_145782_y()));
                    this.pullingUUID = null;
                    if (this.field_70173_aa > 20) {
                        this.playDetachSound();
                    }
                } else {
                    if (entityIn instanceof MobEntity) {
                        ((MobEntity)entityIn).func_70661_as().func_75499_g();
                    }
                    AstikorCarts.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new UpdateDrawnMessage(entityIn.func_145782_y(), this.func_145782_y()));
                    this.pullingUUID = entityIn.func_110124_au();
                    if (this.field_70173_aa > 20) {
                        this.playAttachSound();
                    }
                }
                if (entityIn instanceof AbstractDrawnEntity) {
                    ((AbstractDrawnEntity)entityIn).drawn = this;
                }
                this.pulling = entityIn;
                AstikorWorld.get(this.field_70170_p).ifPresent(w -> w.addPulling(this));
            }
        } else {
            if (entityIn == null) {
                this.pullingId = -1;
                for (CartWheel wheel : this.wheels) {
                    wheel.clearIncrement();
                }
                if (this.pulling instanceof AbstractDrawnEntity) {
                    ((AbstractDrawnEntity)this.pulling).drawn = null;
                }
            } else {
                this.pullingId = entityIn.func_145782_y();
                if (entityIn instanceof AbstractDrawnEntity) {
                    ((AbstractDrawnEntity)entityIn).drawn = this;
                }
            }
            this.pulling = entityIn;
            AstikorWorld.get(this.field_70170_p).ifPresent(w -> w.addPulling(this));
        }
    }

    private void playAttachSound() {
        this.func_184185_a(AstikorCarts.SoundEvents.CART_ATTACHED.get(), 0.2f, 1.0f);
    }

    private void playDetachSound() {
        this.func_184185_a(AstikorCarts.SoundEvents.CART_DETACHED.get(), 0.2f, 1.0f);
    }

    private void attemptReattach() {
        Entity entity;
        if (this.field_70170_p.field_72995_K) {
            Entity entity2;
            if (this.pullingId != -1 && (entity2 = this.field_70170_p.func_73045_a(this.pullingId)) != null && entity2.func_70089_S()) {
                this.setPulling(entity2);
            }
        } else if (this.pullingUUID != null && (entity = ((ServerWorld)this.field_70170_p).func_217461_a(this.pullingUUID)) != null && entity.func_70089_S()) {
            this.setPulling(entity);
        }
    }

    public boolean shouldStopPulledTick() {
        if (!this.func_70089_S() || this.getPulling() == null || !this.getPulling().func_70089_S() || this.getPulling().func_184218_aH()) {
            if (this.pulling != null && this.pulling instanceof PlayerEntity) {
                this.setPulling(null);
            } else {
                this.pulling = null;
            }
            return true;
        }
        if (!this.field_70170_p.field_72995_K && this.shouldRemovePulling()) {
            this.setPulling(null);
            return true;
        }
        return false;
    }

    public Vector3d getRelativeTargetVec(float delta) {
        double z;
        double y;
        double x;
        if (delta == 1.0f) {
            x = this.pulling.func_226277_ct_() - this.func_226277_ct_();
            y = this.pulling.func_226278_cu_() - this.func_226278_cu_();
            z = this.pulling.func_226281_cx_() - this.func_226281_cx_();
        } else {
            x = MathHelper.func_219803_d((double)delta, (double)this.pulling.field_70142_S, (double)this.pulling.func_226277_ct_()) - MathHelper.func_219803_d((double)delta, (double)this.field_70142_S, (double)this.func_226277_ct_());
            y = MathHelper.func_219803_d((double)delta, (double)this.pulling.field_70137_T, (double)this.pulling.func_226278_cu_()) - MathHelper.func_219803_d((double)delta, (double)this.field_70137_T, (double)this.func_226278_cu_());
            z = MathHelper.func_219803_d((double)delta, (double)this.pulling.field_70136_U, (double)this.pulling.func_226281_cx_()) - MathHelper.func_219803_d((double)delta, (double)this.field_70136_U, (double)this.func_226281_cx_());
        }
        float yaw = (float)Math.toRadians(this.pulling.field_70177_z);
        float nx = -MathHelper.func_76126_a((float)yaw);
        float nz = MathHelper.func_76134_b((float)yaw);
        double r = 0.2;
        return new Vector3d(x + (double)nx * 0.2, y, z + (double)nz * 0.2);
    }

    public void handleRotation(Vector3d target) {
        this.field_70177_z = AbstractDrawnEntity.getYaw(target);
        this.field_70125_A = AbstractDrawnEntity.getPitch(target);
    }

    public static float getYaw(Vector3d vec) {
        return MathHelper.func_76142_g((float)((float)Math.toDegrees(-MathHelper.func_181159_b((double)vec.field_72450_a, (double)vec.field_72449_c))));
    }

    public static float getPitch(Vector3d vec) {
        return MathHelper.func_76142_g((float)((float)Math.toDegrees(-MathHelper.func_181159_b((double)vec.field_72448_b, (double)MathHelper.func_76133_a((double)(vec.field_72450_a * vec.field_72450_a + vec.field_72449_c * vec.field_72449_c))))));
    }

    public double getWheelRotation(int wheel) {
        return this.wheels.get(wheel).getRotation();
    }

    public double getWheelRotationIncrement(int wheel) {
        return this.wheels.get(wheel).getRotationIncrement();
    }

    public abstract Item getCartItem();

    protected boolean canBePulledBy(Entity entityIn) {
        if (this.field_70170_p.field_72995_K) {
            return true;
        }
        if (entityIn == null) {
            return true;
        }
        return (this.pulling == null || !this.pulling.func_70089_S()) && !this.func_184196_w(entityIn) && this.canPull(entityIn);
    }

    private boolean canPull(Entity entity) {
        String id = EntityType.func_200718_a((EntityType)entity.func_200600_R()).toString();
        ArrayList allowed = (ArrayList)this.getConfig().pullAnimals.get();
        if (allowed.isEmpty()) {
            return entity instanceof PlayerEntity || entity instanceof IEquipable && ((IEquipable)entity).func_230264_L__() && !(entity instanceof IRideable);
        }
        return allowed.contains(id);
    }

    protected abstract AstikorCartsConfig.CartConfig getConfig();

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            boolean flag;
            if (source == DamageSource.field_76367_g) {
                return false;
            }
            if (source instanceof IndirectEntityDamageSource && source.func_76346_g() != null && this.func_184196_w(source.func_76346_g())) {
                return false;
            }
            this.setForwardDirection(-this.getForwardDirection());
            this.setTimeSinceHit(10);
            this.setDamageTaken(this.getDamageTaken() + amount * 10.0f);
            boolean bl = flag = source.func_76346_g() instanceof PlayerEntity && ((PlayerEntity)source.func_76346_g()).field_71075_bZ.field_75098_d;
            if (flag || this.getDamageTaken() > 40.0f) {
                this.onDestroyed(source, flag);
                this.setPulling(null);
                this.func_70106_y();
            }
            return true;
        }
        return false;
    }

    public void onDestroyed(DamageSource source, boolean byCreativePlayer) {
        if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
            if (!byCreativePlayer) {
                this.func_199703_a((IItemProvider)this.getCartItem());
            }
            this.onDestroyedAndDoDrops(source);
        }
    }

    public void onDestroyedAndDoDrops(DamageSource source) {
    }

    private void tickLerp() {
        if (this.lerpSteps > 0) {
            double dx = (this.lerpX - this.func_226277_ct_()) / (double)this.lerpSteps;
            double dy = (this.lerpY - this.func_226278_cu_()) / (double)this.lerpSteps;
            double dz = (this.lerpZ - this.func_226281_cx_()) / (double)this.lerpSteps;
            this.field_70177_z = (float)((double)this.field_70177_z + MathHelper.func_76138_g((double)(this.lerpYaw - (double)this.field_70177_z)) / (double)this.lerpSteps);
            this.field_70125_A = (float)((double)this.field_70125_A + (this.lerpPitch - (double)this.field_70125_A) / (double)this.lerpSteps);
            --this.lerpSteps;
            this.field_70122_E = true;
            this.func_213315_a(MoverType.SELF, new Vector3d(dx, dy, dz));
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
    }

    public boolean func_96092_aw() {
        return false;
    }

    public boolean func_70067_L() {
        return this.func_70089_S();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYaw = yaw;
        this.lerpPitch = pitch;
        this.lerpSteps = posRotationIncrements;
    }

    protected void func_184200_o(Entity passenger) {
        super.func_184200_o(passenger);
        if (this.func_184186_bw() && this.lerpSteps > 0) {
            this.lerpSteps = 0;
            this.func_70080_a(this.lerpX, this.lerpY, this.lerpZ, (float)this.lerpYaw, (float)this.lerpPitch);
        }
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        List passengers = this.func_184188_bt();
        if (passengers.isEmpty()) {
            return null;
        }
        Entity first = (Entity)passengers.get(0);
        if (first instanceof AnimalEntity || !(first instanceof LivingEntity)) {
            return null;
        }
        return (LivingEntity)first;
    }

    public boolean func_184186_bw() {
        return false;
    }

    public Vector3d func_230268_c_(LivingEntity rider) {
        float[] fArray;
        if (rider.func_184591_cq() == HandSide.RIGHT) {
            float[] fArray2 = new float[2];
            fArray2[0] = 90.0f;
            fArray = fArray2;
            fArray2[1] = -90.0f;
        } else {
            float[] fArray3 = new float[2];
            fArray3[0] = -90.0f;
            fArray = fArray3;
            fArray3[1] = 90.0f;
        }
        for (float angle : fArray) {
            Vector3d pos = this.dismount(AbstractDrawnEntity.func_233559_a_((double)this.func_213311_cf(), (double)rider.func_213311_cf(), (float)(this.field_70177_z + angle)), rider);
            if (pos == null) continue;
            return pos;
        }
        return this.func_213303_ch();
    }

    private Vector3d dismount(Vector3d dir, LivingEntity rider) {
        double x = this.func_226277_ct_() + dir.field_72450_a;
        double y = this.func_174813_aQ().field_72338_b;
        double z = this.func_226281_cx_() + dir.field_72449_c;
        double limit = this.func_174813_aQ().field_72337_e + 0.75;
        BlockPos.Mutable blockPos = new BlockPos.Mutable();
        block0: for (Pose pose : rider.func_230297_ef_()) {
            blockPos.func_189532_c(x, y, z);
            while ((double)blockPos.func_177956_o() < limit) {
                double ground = this.field_70170_p.func_242403_h((BlockPos)blockPos);
                if ((double)blockPos.func_177956_o() + ground > limit) continue block0;
                if (TransportationHelper.func_234630_a_((double)ground)) {
                    Vector3d pos = new Vector3d(x, (double)blockPos.func_177956_o() + ground, z);
                    if (TransportationHelper.func_234631_a_((ICollisionReader)this.field_70170_p, (LivingEntity)rider, (AxisAlignedBB)rider.func_233648_f_(pose).func_191194_a(pos))) {
                        rider.func_213301_b(pose);
                        return pos;
                    }
                }
                blockPos.func_189536_c(Direction.UP);
            }
        }
        return null;
    }

    public void setDamageTaken(float damageTaken) {
        this.field_70180_af.func_187227_b(DAMAGE_TAKEN, (Object)Float.valueOf(damageTaken));
    }

    public float getDamageTaken() {
        return ((Float)this.field_70180_af.func_187225_a(DAMAGE_TAKEN)).floatValue();
    }

    public void setTimeSinceHit(int timeSinceHit) {
        this.field_70180_af.func_187227_b(TIME_SINCE_HIT, (Object)timeSinceHit);
    }

    public int getTimeSinceHit() {
        return (Integer)this.field_70180_af.func_187225_a(TIME_SINCE_HIT);
    }

    public void setForwardDirection(int forwardDirection) {
        this.field_70180_af.func_187227_b(FORWARD_DIRECTION, (Object)forwardDirection);
    }

    public int getForwardDirection() {
        return (Integer)this.field_70180_af.func_187225_a(FORWARD_DIRECTION);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)this.getCartItem());
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeInt(this.pulling != null ? this.pulling.func_145782_y() : -1);
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.pullingId = additionalData.readInt();
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(TIME_SINCE_HIT, (Object)0);
        this.field_70180_af.func_187214_a(FORWARD_DIRECTION, (Object)1);
        this.field_70180_af.func_187214_a(DAMAGE_TAKEN, (Object)Float.valueOf(0.0f));
    }

    protected void func_70037_a(CompoundNBT compound) {
        if (compound.func_186855_b("PullingUUID")) {
            this.pullingUUID = compound.func_186857_a("PullingUUID");
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        if (this.pulling != null) {
            compound.func_186854_a("PullingUUID", this.pullingUUID);
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public RenderInfo getInfo(float delta) {
        return new RenderInfo(delta);
    }

    public void toggleSlow() {
        Entity pulling = this.pulling;
        if (!(pulling instanceof LivingEntity)) {
            return;
        }
        ModifiableAttributeInstance speed = ((LivingEntity)pulling).func_110148_a(Attributes.field_233821_d_);
        if (speed == null) {
            return;
        }
        AttributeModifier modifier = speed.func_111127_a(PULL_SLOWLY_MODIFIER_UUID);
        if (modifier == null) {
            speed.func_233767_b_(new AttributeModifier(PULL_SLOWLY_MODIFIER_UUID, "Pull slowly modifier", ((Double)this.getConfig().slowSpeed.get()).doubleValue(), AttributeModifier.Operation.MULTIPLY_TOTAL));
        } else {
            speed.func_111124_b(modifier);
        }
    }

    public class RenderInfo {
        final float delta;
        Vector3d target;
        float yaw = Float.NaN;
        float pitch = Float.NaN;

        public RenderInfo(float delta) {
            this.delta = delta;
        }

        public Vector3d getTarget() {
            if (this.target == null) {
                this.target = AbstractDrawnEntity.this.pulling == null ? AbstractDrawnEntity.this.func_70676_i(this.delta) : AbstractDrawnEntity.this.getRelativeTargetVec(this.delta);
            }
            return this.target;
        }

        public float getYaw() {
            if (Float.isNaN(this.yaw)) {
                this.yaw = AbstractDrawnEntity.this.pulling == null ? MathHelper.func_219799_g((float)this.delta, (float)AbstractDrawnEntity.this.field_70126_B, (float)AbstractDrawnEntity.this.field_70177_z) : AbstractDrawnEntity.getYaw(this.getTarget());
            }
            return this.yaw;
        }

        public float getPitch() {
            if (Float.isNaN(this.pitch)) {
                this.pitch = AbstractDrawnEntity.this.pulling == null ? MathHelper.func_219799_g((float)this.delta, (float)AbstractDrawnEntity.this.field_70127_C, (float)AbstractDrawnEntity.this.field_70125_A) : AbstractDrawnEntity.getPitch(this.target);
            }
            return this.pitch;
        }
    }
}

